﻿using System;
using VRM.Integration.Servicebus.Core;

namespace VIMT.VirtualMeetingRoom.Services.Configuration
{
    [Serializable]
    public class VirtualMeetingRoomSecurityConfiguration : ObjectConfigHandler
    {
        public static VirtualMeetingRoomSecurityConfiguration Current
        {
            get
            {
                var customConfigurationFileReader = new CustomConfigurationFileReader();

                var section = customConfigurationFileReader.GetCustomConfig<VirtualMeetingRoomSecurityConfiguration>(ConfigurationLocation.ConfigDefiningAssemblyPath,
                     ConfigurationLocation.GetConfigFilePath("EC"),
                    "VirtualMeetingRoomSecurityConfiguration");

                if (section == null) throw new Exception("The Virtual Meeting Room Web Service Security configuration section has not been specified");

                return section;
            }
        }

        public bool RequiresClientCertificate { get; set; }

        public string ClientCertificateName { get; set; }

        public bool EnableLogging { get; set; }
    }
}